/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;

public class ActionMapping
extends ActionConfig {
    private static Log log = LogFactory.getLog(ActionMapping.class);

    public ActionForward findForward(String forwardName) {
        ForwardConfig config = this.findForwardConfig(forwardName);
        if (config == null) {
            config = this.getModuleConfig().findForwardConfig(forwardName);
        }
        if (config == null && log.isWarnEnabled()) {
            log.warn((Object)("Unable to find '" + forwardName + "' forward."));
        }
        return (ActionForward)config;
    }

    public ActionForward findRequiredForward(String forwardName) {
        ActionForward forward = this.findForward(forwardName);
        if (forward == null) {
            throw new IllegalStateException("Unable to find '" + forwardName + "' forward of action path '" + this.getPath() + "'");
        }
        return forward;
    }

    public String[] findForwards() {
        ArrayList<String> results = new ArrayList<String>();
        ForwardConfig[] fcs = this.findForwardConfigs();
        for (int i = 0; i < fcs.length; ++i) {
            results.add(fcs[i].getName());
        }
        return results.toArray(new String[results.size()]);
    }

    public ActionForward getInputForward() {
        String input = this.getInput();
        if (this.getModuleConfig().getControllerConfig().getInputForward()) {
            if (input != null) {
                return this.findForward(input);
            }
            return this.findForward("input");
        }
        return new ActionForward(input);
    }
}

