/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.ResponseUtils;

public class ActionRedirect
extends ActionForward {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    protected static final Log LOG = LogFactory.getLog(ActionRedirect.class);
    protected Map parameterValues = null;
    protected String anchorValue = null;

    public ActionRedirect() {
        this.setRedirect(true);
        this.initializeParameters();
    }

    public ActionRedirect(String path) {
        super(path);
        this.setRedirect(true);
        this.initializeParameters();
    }

    public ActionRedirect(String name, String path, String module) {
        super(name, path, true);
        this.setModule(module);
        this.initializeParameters();
    }

    public ActionRedirect(ForwardConfig baseConfig) {
        this.setName(baseConfig.getName());
        this.setPath(baseConfig.getPath());
        this.setModule(baseConfig.getModule());
        this.setRedirect(true);
        this.inheritProperties(baseConfig);
        this.initializeParameters();
    }

    private void initializeParameters() {
        this.parameterValues = new HashMap();
    }

    public ActionRedirect addParameter(String fieldName, Object valueObj) {
        String value;
        String string = value = valueObj != null ? valueObj.toString() : "";
        if (this.parameterValues == null) {
            this.initializeParameters();
        }
        value = ResponseUtils.encodeURL(value);
        Object currentValue = this.parameterValues.get(fieldName);
        if (currentValue == null) {
            this.parameterValues.put(fieldName, value);
        } else if (currentValue instanceof String) {
            String[] newValue = new String[]{(String)currentValue, value};
            this.parameterValues.put(fieldName, newValue);
        } else if (currentValue instanceof String[]) {
            ArrayList<Object> newValues = new ArrayList<Object>(Arrays.asList((Object[])currentValue));
            newValues.add(value);
            this.parameterValues.put(fieldName, newValues.toArray(new String[newValues.size()]));
        }
        return this;
    }

    public ActionRedirect setAnchor(String anchorValue) {
        this.anchorValue = ResponseUtils.encodeURL(anchorValue);
        return this;
    }

    public String getOriginalPath() {
        return super.getPath();
    }

    @Override
    public String getPath() {
        String originalPath = this.getOriginalPath();
        String parameterString = this.getParameterString();
        String anchorString = this.getAnchorString();
        StringBuffer result = new StringBuffer(originalPath);
        if (parameterString != null && parameterString.length() > 0) {
            String paramSeparator = "?";
            boolean needsParamSeparator = true;
            int paramStartIndex = originalPath.indexOf("?");
            if (paramStartIndex > 0) {
                boolean bl = needsParamSeparator = paramStartIndex != originalPath.length() - 1;
                if (needsParamSeparator) {
                    paramSeparator = "&";
                }
            }
            if (needsParamSeparator) {
                result.append(paramSeparator);
            }
            result.append(parameterString);
        }
        result.append(anchorString);
        return result.toString();
    }

    public String getAnchorString() {
        String retVal = "";
        if (this.anchorValue != null) {
            retVal = "#" + this.anchorValue;
        }
        return retVal;
    }

    public String getParameterString() {
        StringBuffer strParam = new StringBuffer(256);
        Iterator iterator = this.parameterValues.keySet().iterator();
        while (iterator.hasNext()) {
            String paramName = (String)iterator.next();
            Object value = this.parameterValues.get(paramName);
            if (value instanceof String) {
                strParam.append(paramName).append("=").append(value);
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                for (int i = 0; i < values.length; ++i) {
                    strParam.append(paramName).append("=").append(values[i]);
                    if (i >= values.length - 1) continue;
                    strParam.append("&");
                }
            }
            if (!iterator.hasNext()) continue;
            strParam.append("&");
        }
        return strParam.toString();
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append("ActionRedirect [");
        result.append("originalPath=").append(this.getOriginalPath()).append(";");
        result.append("parameterString=").append(this.getParameterString()).append("]");
        result.append("anchorString=").append(this.getAnchorString()).append("]");
        return result.toString();
    }
}

