/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;

public abstract class AbstractCreateAction
extends ActionCommandBase {
    private static final Log LOG = LogFactory.getLog(AbstractCreateAction.class);

    @Override
    public boolean execute(ActionContext actionCtx) throws Exception {
        Boolean valid = actionCtx.getFormValid();
        if (valid == null || !valid.booleanValue()) {
            LOG.trace((Object)"Invalid form; not going to execute.");
            return false;
        }
        if (actionCtx.getAction() != null) {
            LOG.trace((Object)("already have an action [" + actionCtx.getAction() + "]"));
            return false;
        }
        ActionConfig actionConfig = actionCtx.getActionConfig();
        String type = actionConfig.getType();
        if (type == null) {
            String command = actionConfig.getCommand();
            if (command == null && actionConfig.getForward() == null && actionConfig.getInclude() == null) {
                LOG.error((Object)("no type or command for " + actionConfig.getPath()));
            } else {
                LOG.trace((Object)("no type for " + actionConfig.getPath()));
            }
            return false;
        }
        Action action = this.getAction(actionCtx, type, actionConfig);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("setting action to " + action));
        }
        actionCtx.setAction(action);
        return false;
    }

    protected abstract Action getAction(ActionContext var1, String var2, ActionConfig var3) throws Exception;
}

