/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;

public abstract class AbstractPopulateActionForm
extends ActionCommandBase {
    private static final Log log = LogFactory.getLog(AbstractPopulateActionForm.class);

    @Override
    public boolean execute(ActionContext actionCtx) throws Exception {
        ActionConfig actionConfig = actionCtx.getActionConfig();
        ActionForm actionForm = actionCtx.getActionForm();
        this.handleCancel(actionCtx, actionConfig, actionForm);
        if (actionForm == null) {
            return false;
        }
        if (this.isReset(actionCtx, actionConfig)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reseting form bean '" + actionConfig.getName() + "'"));
            }
            this.reset(actionCtx, actionConfig, actionForm);
        }
        if (this.isPopulate(actionCtx, actionConfig)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Populating form bean '" + actionConfig.getName() + "'"));
            }
            this.populate(actionCtx, actionConfig, actionForm);
        }
        return false;
    }

    protected abstract boolean isReset(ActionContext var1, ActionConfig var2);

    protected abstract boolean isPopulate(ActionContext var1, ActionConfig var2);

    protected abstract void reset(ActionContext var1, ActionConfig var2, ActionForm var3);

    protected abstract void populate(ActionContext var1, ActionConfig var2, ActionForm var3) throws Exception;

    protected String trimParameterName(ActionConfig actionConfig, String name) {
        String stripped = name;
        String prefix = actionConfig.getPrefix();
        String suffix = actionConfig.getSuffix();
        if (prefix != null) {
            if (!stripped.startsWith(prefix)) {
                return null;
            }
            stripped = stripped.substring(prefix.length());
        }
        if (suffix != null) {
            if (!stripped.endsWith(suffix)) {
                return null;
            }
            stripped = stripped.substring(0, stripped.length() - suffix.length());
        }
        return stripped;
    }

    protected void handleCancel(ActionContext context, ActionConfig actionConfig, ActionForm actionForm) throws Exception {
        Map paramValues = context.getParameterMap();
        if (paramValues.get("org.apache.struts.taglib.html.CANCEL") != null || paramValues.get("org.apache.struts.taglib.html.CANCEL.x") != null) {
            context.setCancelled(Boolean.TRUE);
        } else {
            context.setCancelled(Boolean.FALSE);
        }
    }
}

