/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;

public abstract class AbstractSelectInput
extends ActionCommandBase {
    private static final Log LOG = LogFactory.getLog(AbstractSelectInput.class);

    @Override
    public boolean execute(ActionContext actionCtx) throws Exception {
        Boolean valid = actionCtx.getFormValid();
        if (valid != null && valid.booleanValue()) {
            return false;
        }
        ActionConfig actionConfig = actionCtx.getActionConfig();
        ModuleConfig moduleConfig = actionConfig.getModuleConfig();
        ForwardConfig forwardConfig = null;
        String input = actionConfig.getInput();
        if (moduleConfig.getControllerConfig().getInputForward()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Finding ForwardConfig for '" + input + "'"));
            }
            if ((forwardConfig = this.inputForward(actionConfig, moduleConfig, input)) == null) {
                LOG.error((Object)this.getErrorMessage(actionCtx, actionConfig));
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Delegating to forward() for '" + input + "'"));
            }
            forwardConfig = this.forward(actionCtx, moduleConfig, input);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Forwarding back to " + forwardConfig));
        }
        actionCtx.setForwardConfig(forwardConfig);
        return false;
    }

    protected abstract ForwardConfig forward(ActionContext var1, ModuleConfig var2, String var3);

    protected abstract String getErrorMessage(ActionContext var1, ActionConfig var2);

    protected ForwardConfig inputForward(ActionConfig actionConfig, ModuleConfig moduleConfig, String input) {
        ForwardConfig forwardConfig;
        if (input != null) {
            forwardConfig = actionConfig.findForwardConfig(input);
            if (forwardConfig == null) {
                forwardConfig = moduleConfig.findForwardConfig(input);
            }
        } else {
            forwardConfig = actionConfig.findForwardConfig("input");
            if (forwardConfig == null) {
                forwardConfig = moduleConfig.findForwardConfig("input");
            }
        }
        return forwardConfig;
    }
}

