/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands.generic;

import org.apache.struts.action.ActionForm;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ActionContextBase;
import org.apache.struts.config.ActionConfig;

public class CopyFormToContext
extends ActionCommandBase {
    private String formName = null;
    private String scope = null;
    private String actionPath = null;
    private String toKey = "actionForm";

    public String getActionPath() {
        return this.actionPath;
    }

    public void setActionPath(String actionPath) {
        this.actionPath = actionPath;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getToKey() {
        return this.toKey;
    }

    public void setToKey(String toKey) {
        this.toKey = toKey;
    }

    @Override
    public boolean execute(ActionContext actionContext) throws Exception {
        ActionForm form = this.findOrCreateForm(actionContext);
        if (this.isEmpty(this.getToKey())) {
            throw new IllegalStateException("Property 'toKey' must be defined.");
        }
        actionContext.put(this.getToKey(), form);
        return false;
    }

    protected ActionForm findOrCreateForm(ActionContext context) throws IllegalAccessException, InstantiationException {
        String effectiveScope;
        String effectiveFormName;
        if (!this.isEmpty(this.getActionPath())) {
            ActionConfig actionConfig = context.getModuleConfig().findActionConfig(this.getActionPath());
            if (actionConfig == null) {
                throw new IllegalArgumentException("No ActionConfig found for path " + this.getActionPath());
            }
            effectiveFormName = actionConfig.getName();
            effectiveScope = actionConfig.getScope();
        } else {
            effectiveFormName = this.getFormName();
            effectiveScope = this.getScope();
        }
        if (this.isEmpty(effectiveScope) || this.isEmpty(effectiveFormName)) {
            throw new IllegalStateException("Both scope [" + effectiveScope + "] and formName [" + effectiveFormName + "] must be defined.");
        }
        return this.findOrCreateForm(context, effectiveFormName, effectiveScope);
    }

    protected ActionForm findOrCreateForm(ActionContext ctx, String effectiveFormName, String effectiveScope) throws IllegalAccessException, InstantiationException {
        ActionContextBase context;
        try {
            context = (ActionContextBase)ctx;
        }
        catch (ClassCastException e) {
            IllegalStateException e2 = new IllegalStateException("ActionContext [" + ctx + "] must be subclass of ActionContextBase");
            e2.initCause(e);
            throw e2;
        }
        ActionForm form = context.findOrCreateActionForm(effectiveFormName, effectiveScope);
        if (form == null) {
            throw new IllegalArgumentException("No form found under scope [" + effectiveScope + "] and formName [" + effectiveFormName + "]");
        }
        return form;
    }

    private boolean isEmpty(String test) {
        return test == null || test.trim().length() == 0;
    }
}

