/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.contexts;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.impl.ContextBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ContextWrapper;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.TokenProcessor;

public abstract class ActionContextBase
extends ContextWrapper
implements ActionContext {
    public static final String ACTION_KEY = "action";
    public static final String ACTION_CONFIG_KEY = "actionConfig";
    public static final String ACTION_FORM_KEY = "actionForm";
    public static final String FORWARD_CONFIG_KEY = "forwardConfig";
    public static final String MODULE_CONFIG_KEY = "moduleConfig";
    public static final String EXCEPTION_KEY = "exception";
    public static final String ERROR_ACTION_MESSAGES_KEY = "errors";
    public static final String MESSAGE_ACTION_MESSAGES_KEY = "messages";
    public static final String MESSAGE_RESOURCES_KEY = "messageResources";
    public static final String INCLUDE_KEY = "include";
    public static final String LOCALE_KEY = "locale";
    public static final String CANCEL_KEY = "cancel";
    public static final String VALID_KEY = "valid";
    public static final String TRANSACTION_TOKEN_KEY = "TRANSACTION_TOKEN_KEY";
    public static final String TOKEN_KEY = "TOKEN_KEY";
    protected TokenProcessor token = TokenProcessor.getInstance();
    private Log logger = LogFactory.getLog(this.getClass());

    public ActionContextBase(Context context) {
        super(context);
    }

    public ActionContextBase() {
        this((Context)new ContextBase());
    }

    @Override
    public void release() {
        this.token = null;
    }

    @Override
    public abstract Map getApplicationScope();

    @Override
    public abstract Map getRequestScope();

    @Override
    public abstract Map getSessionScope();

    @Override
    public Map getScope(String scopeName) {
        if ("request".equals(scopeName)) {
            return this.getRequestScope();
        }
        if ("session".equals(scopeName)) {
            return this.getSessionScope();
        }
        if ("application".equals(scopeName)) {
            return this.getApplicationScope();
        }
        throw new IllegalArgumentException("Invalid scope: " + scopeName);
    }

    @Override
    public void setAction(Action action) {
        this.put(ACTION_KEY, action);
    }

    @Override
    public Action getAction() {
        return (Action)this.get(ACTION_KEY);
    }

    @Override
    public void setActionForm(ActionForm form) {
        this.put(ACTION_FORM_KEY, form);
    }

    @Override
    public ActionForm getActionForm() {
        return (ActionForm)this.get(ACTION_FORM_KEY);
    }

    @Override
    public void setActionConfig(ActionConfig config) {
        this.put(ACTION_CONFIG_KEY, config);
    }

    @Override
    public ActionConfig getActionConfig() {
        return (ActionConfig)this.get(ACTION_CONFIG_KEY);
    }

    @Override
    public void setForwardConfig(ForwardConfig forward) {
        this.put(FORWARD_CONFIG_KEY, forward);
    }

    @Override
    public ForwardConfig getForwardConfig() {
        return (ForwardConfig)this.get(FORWARD_CONFIG_KEY);
    }

    @Override
    public void setInclude(String include) {
        this.put(INCLUDE_KEY, include);
    }

    @Override
    public String getInclude() {
        return (String)this.get(INCLUDE_KEY);
    }

    @Override
    public Boolean getFormValid() {
        return (Boolean)this.get(VALID_KEY);
    }

    @Override
    public void setFormValid(Boolean valid) {
        this.put(VALID_KEY, valid);
    }

    @Override
    public ModuleConfig getModuleConfig() {
        return (ModuleConfig)this.get(MODULE_CONFIG_KEY);
    }

    @Override
    public void setModuleConfig(ModuleConfig config) {
        this.put(MODULE_CONFIG_KEY, config);
    }

    @Override
    public Exception getException() {
        return (Exception)this.get(EXCEPTION_KEY);
    }

    @Override
    public void setException(Exception e) {
        this.put(EXCEPTION_KEY, e);
    }

    @Override
    public void addMessages(ActionMessages messages) {
        this.addActionMessages(MESSAGE_ACTION_MESSAGES_KEY, messages);
    }

    @Override
    public void addErrors(ActionMessages errors) {
        this.addActionMessages(ERROR_ACTION_MESSAGES_KEY, errors);
    }

    @Override
    public ActionMessages getErrors() {
        return (ActionMessages)this.get(ERROR_ACTION_MESSAGES_KEY);
    }

    @Override
    public ActionMessages getMessages() {
        return (ActionMessages)this.get(MESSAGE_ACTION_MESSAGES_KEY);
    }

    @Override
    public void saveErrors(ActionMessages errors) {
        this.saveActionMessages(ERROR_ACTION_MESSAGES_KEY, errors);
    }

    @Override
    public void saveMessages(ActionMessages messages) {
        this.saveActionMessages(MESSAGE_ACTION_MESSAGES_KEY, messages);
    }

    public void addActionMessages(String key, ActionMessages messages) {
        if (messages == null) {
            return;
        }
        ActionMessages requestMessages = (ActionMessages)this.get(key);
        if (requestMessages == null) {
            requestMessages = new ActionMessages();
        }
        requestMessages.add(messages);
        this.remove(key);
        this.saveActionMessages(key, requestMessages);
    }

    public void saveActionMessages(String key, ActionMessages messages) {
        this.saveActionMessages("request", key, messages);
    }

    public void saveActionMessages(String scopeId, String key, ActionMessages messages) {
        Map scope = this.getScope(scopeId);
        if (messages == null || messages.isEmpty()) {
            scope.remove(key);
            return;
        }
        scope.put(key, messages);
    }

    @Override
    public void saveMessages(String scope, ActionMessages messages) {
        this.saveMessages(messages);
    }

    @Override
    public void saveToken() {
        String token = this.generateToken();
        this.put(TRANSACTION_TOKEN_KEY, token);
    }

    @Override
    public String generateToken() {
        return this.token.generateToken(this.getTokenGeneratorId());
    }

    protected String getTokenGeneratorId() {
        return "";
    }

    @Override
    public boolean isTokenValid() {
        return this.isTokenValid(false);
    }

    @Override
    public boolean isTokenValid(boolean reset) {
        String token;
        String saved = (String)this.get(TRANSACTION_TOKEN_KEY);
        if (saved == null) {
            return false;
        }
        if (reset) {
            this.resetToken();
        }
        if ((token = (String)this.get(TOKEN_KEY)) == null) {
            return false;
        }
        return saved.equals(token);
    }

    @Override
    public void resetToken() {
        this.remove(TRANSACTION_TOKEN_KEY);
    }

    @Override
    public Boolean getCancelled() {
        return (Boolean)this.get(CANCEL_KEY);
    }

    @Override
    public void setCancelled(Boolean cancelled) {
        this.put(CANCEL_KEY, cancelled);
    }

    @Override
    public void setMessageResources(MessageResources messageResources) {
        this.put(MESSAGE_RESOURCES_KEY, messageResources);
    }

    @Override
    public MessageResources getMessageResources() {
        return (MessageResources)this.get(MESSAGE_RESOURCES_KEY);
    }

    @Override
    public MessageResources getMessageResources(String key) {
        return (MessageResources)this.get(key);
    }

    @Override
    public void setLocale(Locale locale) {
        this.put(LOCALE_KEY, locale);
    }

    @Override
    public Locale getLocale() {
        return (Locale)this.get(LOCALE_KEY);
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public ActionForm findOrCreateActionForm(String formName, String scopeName) throws IllegalAccessException, InstantiationException {
        return this.findOrCreateActionForm(formName, scopeName, this.getModuleConfig());
    }

    public ActionForm findOrCreateActionForm(String formName, String scopeName, ModuleConfig moduleConfig) throws IllegalAccessException, InstantiationException {
        Map scope = this.getScope(scopeName);
        FormBeanConfig formBeanConfig = moduleConfig.findFormBeanConfig(formName);
        if (formBeanConfig == null) {
            throw new IllegalArgumentException("No form config found under " + formName + " in module " + moduleConfig.getPrefix());
        }
        ActionForm instance = (ActionForm)scope.get(formName);
        if (instance != null) {
            this.getLogger().trace((Object)("Found an instance in scope " + scopeName + "; test for reusability"));
            if (formBeanConfig.canReuse(instance)) {
                return instance;
            }
        }
        ActionForm form = formBeanConfig.createActionForm(this);
        scope.put(formName, form);
        return form;
    }
}

