/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config.impl;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ActionConfigMatcher;
import org.apache.struts.config.BaseConfig;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;

public class ModuleConfigImpl
extends BaseConfig
implements Serializable,
ModuleConfig {
    protected static Log log = LogFactory.getLog(ModuleConfigImpl.class);
    protected Map actionConfigs = null;
    protected HashMap actionConfigIds = null;
    protected List actionConfigList = null;
    protected HashMap exceptions = null;
    protected HashMap formBeans = null;
    protected HashMap forwards = null;
    protected HashMap messageResources = null;
    protected ArrayList plugIns = null;
    protected ControllerConfig controllerConfig = null;
    protected String prefix = null;
    protected String actionFormBeanClass = "org.apache.struts.action.ActionFormBean";
    protected String actionMappingClass = "org.apache.struts.action.ActionMapping";
    protected String actionForwardClass = "org.apache.struts.action.ActionForward";
    protected ActionConfigMatcher matcher = null;

    public ModuleConfigImpl() {
        this("");
    }

    public ModuleConfigImpl(String prefix) {
        this.prefix = prefix;
        this.actionConfigs = new HashMap();
        this.actionConfigIds = new HashMap();
        this.actionConfigList = new ArrayList();
        this.actionFormBeanClass = "org.apache.struts.action.ActionFormBean";
        this.actionMappingClass = "org.apache.struts.action.ActionMapping";
        this.actionForwardClass = "org.apache.struts.action.ActionForward";
        this.configured = false;
        this.controllerConfig = null;
        this.exceptions = new HashMap();
        this.formBeans = new HashMap();
        this.forwards = new HashMap();
        this.messageResources = new HashMap();
        this.plugIns = new ArrayList();
    }

    @Override
    public boolean getConfigured() {
        return this.configured;
    }

    @Override
    public ControllerConfig getControllerConfig() {
        if (this.controllerConfig == null) {
            this.controllerConfig = new ControllerConfig();
        }
        return this.controllerConfig;
    }

    @Override
    public void setControllerConfig(ControllerConfig cc) {
        this.throwIfConfigured();
        this.controllerConfig = cc;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.throwIfConfigured();
        this.prefix = prefix;
    }

    @Override
    public String getActionFormBeanClass() {
        return this.actionFormBeanClass;
    }

    @Override
    public void setActionFormBeanClass(String actionFormBeanClass) {
        this.actionFormBeanClass = actionFormBeanClass;
    }

    @Override
    public String getActionMappingClass() {
        return this.actionMappingClass;
    }

    @Override
    public void setActionMappingClass(String actionMappingClass) {
        this.actionMappingClass = actionMappingClass;
    }

    @Override
    public void addActionConfig(ActionConfig config) {
        String actionId;
        this.throwIfConfigured();
        config.setModuleConfig(this);
        String path = config.getPath();
        if (this.actionConfigs.containsKey(path)) {
            log.warn((Object)("Overriding ActionConfig of path " + path));
        }
        if ((actionId = config.getActionId()) != null && !actionId.equals("")) {
            if (this.actionConfigIds.containsKey(actionId) && log.isWarnEnabled()) {
                ActionConfig otherConfig = (ActionConfig)this.actionConfigIds.get(actionId);
                StringBuffer msg = new StringBuffer("Overriding actionId[");
                msg.append(actionId);
                msg.append("] for path[");
                msg.append(otherConfig.getPath());
                msg.append("] with path[");
                msg.append(path);
                msg.append("]");
                log.warn((Object)msg);
            }
            this.actionConfigIds.put(actionId, config);
        }
        this.actionConfigs.put(path, config);
        this.actionConfigList.add(config);
    }

    @Override
    public void addExceptionConfig(ExceptionConfig config) {
        this.throwIfConfigured();
        String key = config.getType();
        if (this.exceptions.containsKey(key)) {
            log.warn((Object)("Overriding ExceptionConfig of type " + key));
        }
        this.exceptions.put(key, config);
    }

    @Override
    public void addFormBeanConfig(FormBeanConfig config) {
        this.throwIfConfigured();
        String key = config.getName();
        if (this.formBeans.containsKey(key)) {
            log.warn((Object)("Overriding ActionForm of name " + key));
        }
        this.formBeans.put(key, config);
    }

    @Override
    public String getActionForwardClass() {
        return this.actionForwardClass;
    }

    @Override
    public void setActionForwardClass(String actionForwardClass) {
        this.actionForwardClass = actionForwardClass;
    }

    @Override
    public void addForwardConfig(ForwardConfig config) {
        this.throwIfConfigured();
        String key = config.getName();
        if (this.forwards.containsKey(key)) {
            log.warn((Object)("Overriding global ActionForward of name " + key));
        }
        this.forwards.put(key, config);
    }

    @Override
    public void addMessageResourcesConfig(MessageResourcesConfig config) {
        this.throwIfConfigured();
        String key = config.getKey();
        if (this.messageResources.containsKey(key)) {
            log.warn((Object)("Overriding MessageResources bundle of key " + key));
        }
        this.messageResources.put(key, config);
    }

    @Override
    public void addPlugInConfig(PlugInConfig plugInConfig) {
        this.throwIfConfigured();
        this.plugIns.add(plugInConfig);
    }

    @Override
    public ActionConfig findActionConfig(String path) {
        ActionConfig config = (ActionConfig)this.actionConfigs.get(path);
        if (config == null && this.matcher != null) {
            config = this.matcher.match(path);
        }
        return config;
    }

    @Override
    public ActionConfig findActionConfigId(String actionId) {
        if (actionId != null) {
            return (ActionConfig)this.actionConfigIds.get(actionId);
        }
        return null;
    }

    @Override
    public ActionConfig[] findActionConfigs() {
        ActionConfig[] results = new ActionConfig[this.actionConfigList.size()];
        return this.actionConfigList.toArray(results);
    }

    @Override
    public ExceptionConfig findExceptionConfig(String type) {
        return (ExceptionConfig)this.exceptions.get(type);
    }

    @Override
    public ExceptionConfig findException(Class type) {
        ExceptionConfig config = null;
        do {
            String name = type.getName();
            log.debug((Object)("findException: look locally for " + name));
            config = this.findExceptionConfig(name);
            if (config == null) continue;
            return config;
        } while ((type = type.getSuperclass()) != null);
        return null;
    }

    @Override
    public ExceptionConfig[] findExceptionConfigs() {
        ExceptionConfig[] results = new ExceptionConfig[this.exceptions.size()];
        return this.exceptions.values().toArray(results);
    }

    @Override
    public FormBeanConfig findFormBeanConfig(String name) {
        return (FormBeanConfig)this.formBeans.get(name);
    }

    @Override
    public FormBeanConfig[] findFormBeanConfigs() {
        FormBeanConfig[] results = new FormBeanConfig[this.formBeans.size()];
        return this.formBeans.values().toArray(results);
    }

    @Override
    public ForwardConfig findForwardConfig(String name) {
        return (ForwardConfig)this.forwards.get(name);
    }

    @Override
    public ForwardConfig[] findForwardConfigs() {
        ForwardConfig[] results = new ForwardConfig[this.forwards.size()];
        return this.forwards.values().toArray(results);
    }

    @Override
    public MessageResourcesConfig findMessageResourcesConfig(String key) {
        return (MessageResourcesConfig)this.messageResources.get(key);
    }

    @Override
    public MessageResourcesConfig[] findMessageResourcesConfigs() {
        MessageResourcesConfig[] results = new MessageResourcesConfig[this.messageResources.size()];
        return this.messageResources.values().toArray(results);
    }

    @Override
    public PlugInConfig[] findPlugInConfigs() {
        PlugInConfig[] results = new PlugInConfig[this.plugIns.size()];
        return this.plugIns.toArray(results);
    }

    @Override
    public void freeze() {
        super.freeze();
        ActionConfig[] aconfigs = this.findActionConfigs();
        for (int i = 0; i < aconfigs.length; ++i) {
            aconfigs[i].freeze();
        }
        this.matcher = new ActionConfigMatcher(aconfigs);
        this.getControllerConfig().freeze();
        ExceptionConfig[] econfigs = this.findExceptionConfigs();
        for (int i = 0; i < econfigs.length; ++i) {
            econfigs[i].freeze();
        }
        FormBeanConfig[] fbconfigs = this.findFormBeanConfigs();
        for (int i = 0; i < fbconfigs.length; ++i) {
            fbconfigs[i].freeze();
        }
        ForwardConfig[] fconfigs = this.findForwardConfigs();
        for (int i = 0; i < fconfigs.length; ++i) {
            fconfigs[i].freeze();
        }
        MessageResourcesConfig[] mrconfigs = this.findMessageResourcesConfigs();
        for (int i = 0; i < mrconfigs.length; ++i) {
            mrconfigs[i].freeze();
        }
        PlugInConfig[] piconfigs = this.findPlugInConfigs();
        for (int i = 0; i < piconfigs.length; ++i) {
            piconfigs[i].freeze();
        }
    }

    @Override
    public void removeActionConfig(ActionConfig config) {
        this.throwIfConfigured();
        config.setModuleConfig(null);
        this.actionConfigs.remove(config.getPath());
        this.actionConfigList.remove(config);
    }

    @Override
    public void removeExceptionConfig(ExceptionConfig config) {
        this.throwIfConfigured();
        this.exceptions.remove(config.getType());
    }

    @Override
    public void removeFormBeanConfig(FormBeanConfig config) {
        this.throwIfConfigured();
        this.formBeans.remove(config.getName());
    }

    @Override
    public void removeForwardConfig(ForwardConfig config) {
        this.throwIfConfigured();
        this.forwards.remove(config.getName());
    }

    @Override
    public void removeMessageResourcesConfig(MessageResourcesConfig config) {
        this.throwIfConfigured();
        this.messageResources.remove(config.getKey());
    }

    @Override
    public void setProperty(String key, String value) {
        super.setProperty(key, value);
        if ("struts.url.caseSensitive".equals(key)) {
            AbstractMap actionConfigs2 = Boolean.valueOf(value) == false ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new HashMap();
            actionConfigs2.putAll(this.actionConfigs);
            this.actionConfigs = actionConfigs2;
        }
    }
}

