/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.dispatcher;

import java.lang.reflect.Method;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.dispatcher.MethodResolver;

public abstract class AbstractMethodResolver
implements MethodResolver {
    protected static final Object[] EMPTY_ARGUMENTS = new Object[0];
    protected static final Class[] EMPTY_ARGUMENT_TYPES = new Class[0];
    private static final Class[] ACTION_CONTEXT_ARGUMENT_TYPES = new Class[]{ActionContext.class};

    @Override
    public Object[] buildArguments(ActionContext context, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        switch (parameterTypes.length) {
            case 0: {
                return EMPTY_ARGUMENTS;
            }
            case 1: {
                if (parameterTypes[0].isInstance(context)) {
                    return new Object[]{context};
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public Method resolveMethod(ActionContext context, String methodName) throws NoSuchMethodException {
        Class<?> actionClass = context.getAction().getClass();
        try {
            return actionClass.getMethod(methodName, EMPTY_ARGUMENT_TYPES);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return actionClass.getMethod(methodName, ACTION_CONTEXT_ARGUMENT_TYPES);
        }
    }
}

