/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.FormFile;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;

public class CommonsMultipartRequestHandler
implements MultipartRequestHandler {
    public static final long DEFAULT_SIZE_MAX = 0xFA00000L;
    public static final int DEFAULT_SIZE_THRESHOLD = 262144;
    protected static Log log = LogFactory.getLog(CommonsMultipartRequestHandler.class);
    private Hashtable elementsAll;
    private Hashtable elementsFile;
    private Hashtable elementsText;
    private ActionMapping mapping;
    private ActionServlet servlet;

    @Override
    public ActionServlet getServlet() {
        return this.servlet;
    }

    @Override
    public void setServlet(ActionServlet servlet) {
        this.servlet = servlet;
    }

    @Override
    public ActionMapping getMapping() {
        return this.mapping;
    }

    @Override
    public void setMapping(ActionMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public void handleRequest(HttpServletRequest request) throws ServletException {
        ModuleConfig ac = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        DiskFileUpload upload = new DiskFileUpload();
        upload.setHeaderEncoding(request.getCharacterEncoding());
        upload.setSizeMax(this.getSizeMax(ac));
        upload.setSizeThreshold((int)this.getSizeThreshold(ac));
        upload.setRepositoryPath(this.getRepositoryPath(ac));
        this.elementsText = new Hashtable();
        this.elementsFile = new Hashtable();
        this.elementsAll = new Hashtable();
        List items = null;
        try {
            items = upload.parseRequest(request);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            request.setAttribute("org.apache.struts.upload.MaxLengthExceeded", (Object)Boolean.TRUE);
            this.clearInputStream(request);
            return;
        }
        catch (FileUploadException e) {
            log.error((Object)"Failed to parse multipart request", (Throwable)e);
            this.clearInputStream(request);
            throw new ServletException((Throwable)e);
        }
        for (FileItem item : items) {
            if (item.isFormField()) {
                this.addTextParameter(request, item);
                continue;
            }
            this.addFileParameter(item);
        }
    }

    @Override
    public Hashtable getTextElements() {
        return this.elementsText;
    }

    @Override
    public Hashtable getFileElements() {
        return this.elementsFile;
    }

    @Override
    public Hashtable getAllElements() {
        return this.elementsAll;
    }

    @Override
    public void rollback() {
        for (Object o : this.elementsFile.values()) {
            if (o instanceof List) {
                Iterator i = ((List)o).iterator();
                while (i.hasNext()) {
                    ((FormFile)i.next()).destroy();
                }
                continue;
            }
            ((FormFile)o).destroy();
        }
    }

    @Override
    public void finish() {
        this.rollback();
    }

    protected void clearInputStream(HttpServletRequest request) {
        try {
            if (System.getProperty("os.name").indexOf("Windows") >= -1) {
                ServletInputStream is = request.getInputStream();
                byte[] data = new byte[262144];
                int bytesRead = 0;
                while ((bytesRead = is.read(data)) > -1) {
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected long getSizeMax(ModuleConfig mc) {
        return this.convertSizeToBytes(mc.getControllerConfig().getMaxFileSize(), 0xFA00000L);
    }

    protected long getSizeThreshold(ModuleConfig mc) {
        return this.convertSizeToBytes(mc.getControllerConfig().getMemFileSize(), 262144L);
    }

    protected long convertSizeToBytes(String sizeString, long defaultSize) {
        int multiplier = 1;
        if (sizeString.endsWith("K")) {
            multiplier = 1024;
        } else if (sizeString.endsWith("M")) {
            multiplier = 0x100000;
        } else if (sizeString.endsWith("G")) {
            multiplier = 0x40000000;
        }
        if (multiplier != 1) {
            sizeString = sizeString.substring(0, sizeString.length() - 1);
        }
        long size = 0L;
        try {
            size = Long.parseLong(sizeString);
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)("Invalid format for file size ('" + sizeString + "'). Using default."));
            size = defaultSize;
            multiplier = 1;
        }
        return size * (long)multiplier;
    }

    protected String getRepositoryPath(ModuleConfig mc) {
        String tempDir = mc.getControllerConfig().getTempDir();
        if (tempDir == null || tempDir.length() == 0) {
            if (this.servlet != null) {
                ServletContext context = this.servlet.getServletContext();
                File tempDirFile = (File)context.getAttribute("javax.servlet.context.tempdir");
                tempDir = tempDirFile.getAbsolutePath();
            }
            if (tempDir == null || tempDir.length() == 0) {
                tempDir = System.getProperty("java.io.tmpdir");
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("File upload temp dir: " + tempDir));
        }
        return tempDir;
    }

    protected void addTextParameter(HttpServletRequest request, FileItem item) {
        String[] newArray;
        String[] oldArray;
        String name = item.getFieldName();
        String value = null;
        boolean haveValue = false;
        String encoding = null;
        if (item instanceof DiskFileItem) {
            encoding = ((DiskFileItem)item).getCharSet();
            if (log.isDebugEnabled()) {
                log.debug((Object)("DiskFileItem.getCharSet=[" + encoding + "]"));
            }
        }
        if (encoding == null) {
            encoding = request.getCharacterEncoding();
            if (log.isDebugEnabled()) {
                log.debug((Object)("request.getCharacterEncoding=[" + encoding + "]"));
            }
        }
        if (encoding != null) {
            try {
                value = item.getString(encoding);
                haveValue = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!haveValue) {
            try {
                value = item.getString("ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                value = item.getString();
            }
            haveValue = true;
        }
        if (request instanceof MultipartRequestWrapper) {
            MultipartRequestWrapper wrapper = (MultipartRequestWrapper)request;
            wrapper.setParameter(name, value);
        }
        if ((oldArray = (String[])this.elementsText.get(name)) != null) {
            newArray = new String[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = value;
        } else {
            newArray = new String[]{value};
        }
        this.elementsText.put(name, newArray);
        this.elementsAll.put(name, newArray);
    }

    protected void addFileParameter(FileItem item) {
        CommonsFormFile formFile = new CommonsFormFile(item);
        String name = item.getFieldName();
        if (this.elementsFile.containsKey(name)) {
            Object o = this.elementsFile.get(name);
            if (o instanceof List) {
                ((List)o).add(formFile);
            } else {
                ArrayList<FormFile> list = new ArrayList<FormFile>();
                list.add((FormFile)o);
                list.add(formFile);
                this.elementsFile.put(name, list);
                this.elementsAll.put(name, list);
            }
        } else {
            this.elementsFile.put(name, formFile);
            this.elementsAll.put(name, formFile);
        }
    }

    static class CommonsFormFile
    implements FormFile,
    Serializable {
        FileItem fileItem;

        public CommonsFormFile(FileItem fileItem) {
            this.fileItem = fileItem;
        }

        @Override
        public String getContentType() {
            return this.fileItem.getContentType();
        }

        @Override
        public void setContentType(String contentType) {
            throw new UnsupportedOperationException("The setContentType() method is not supported.");
        }

        @Override
        public int getFileSize() {
            long size = this.fileItem.getSize();
            if (size > Integer.MAX_VALUE) {
                throw new IllegalStateException("Size is greater than 2 GB; use getFileLength()");
            }
            return (int)size;
        }

        @Override
        public void setFileSize(int filesize) {
            throw new UnsupportedOperationException("The setFileSize() method is not supported.");
        }

        @Override
        public long getFileLength() {
            return this.fileItem.getSize();
        }

        @Override
        public void setFileLength(long fileLength) {
            throw new UnsupportedOperationException("The setFileLength() method is not supported.");
        }

        @Override
        public String getFileName() {
            return this.getBaseFileName(this.fileItem.getName());
        }

        @Override
        public void setFileName(String fileName) {
            throw new UnsupportedOperationException("The setFileName() method is not supported.");
        }

        @Override
        public byte[] getFileData() throws FileNotFoundException, IOException {
            return this.fileItem.get();
        }

        @Override
        public InputStream getInputStream() throws FileNotFoundException, IOException {
            return this.fileItem.getInputStream();
        }

        @Override
        public void destroy() {
            this.fileItem.delete();
        }

        protected String getBaseFileName(String filePath) {
            String fileName = new File(filePath).getName();
            int colonIndex = fileName.indexOf(":");
            if (colonIndex == -1) {
                colonIndex = fileName.indexOf("\\\\");
            }
            int backslashIndex = fileName.lastIndexOf("\\");
            if (colonIndex > -1 && backslashIndex > -1) {
                fileName = fileName.substring(backslashIndex + 1);
            }
            return fileName;
        }

        public String toString() {
            return this.getFileName();
        }
    }
}

