/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResourcesFactory;

public abstract class MessageResources
implements Serializable {
    protected static Log log = LogFactory.getLog(MessageResources.class);
    protected static MessageResourcesFactory defaultFactory = null;
    protected String config = null;
    protected Locale defaultLocale = Locale.getDefault();
    protected MessageResourcesFactory factory = null;
    protected HashMap formats = new HashMap();
    protected boolean returnNull = false;
    private boolean escape = true;

    public MessageResources(MessageResourcesFactory factory, String config) {
        this(factory, config, false);
    }

    public MessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        this.factory = factory;
        this.config = config;
        this.returnNull = returnNull;
    }

    public String getConfig() {
        return this.config;
    }

    public MessageResourcesFactory getFactory() {
        return this.factory;
    }

    public boolean getReturnNull() {
        return this.returnNull;
    }

    public void setReturnNull(boolean returnNull) {
        this.returnNull = returnNull;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public String getMessage(String key) {
        return this.getMessage((Locale)null, key, null);
    }

    public String getMessage(String key, Object[] args) {
        return this.getMessage((Locale)null, key, args);
    }

    public String getMessage(String key, Object arg0) {
        return this.getMessage((Locale)null, key, arg0);
    }

    public String getMessage(String key, Object arg0, Object arg1) {
        return this.getMessage((Locale)null, key, arg0, arg1);
    }

    public String getMessage(String key, Object arg0, Object arg1, Object arg2) {
        return this.getMessage((Locale)null, key, arg0, arg1, arg2);
    }

    public String getMessage(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        return this.getMessage(null, key, arg0, arg1, arg2, arg3);
    }

    public abstract String getMessage(Locale var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(Locale locale, String key, Object[] args) {
        if (locale == null) {
            locale = this.defaultLocale;
        }
        MessageFormat format = null;
        String formatKey = this.messageKey(locale, key);
        HashMap hashMap = this.formats;
        synchronized (hashMap) {
            format = (MessageFormat)this.formats.get(formatKey);
            if (format == null) {
                String formatString = this.getMessage(locale, key);
                if (formatString == null) {
                    return this.returnNull ? null : "???" + formatKey + "???";
                }
                format = new MessageFormat(this.escape(formatString));
                format.setLocale(locale);
                this.formats.put(formatKey, format);
            }
        }
        return format.format(args);
    }

    public String getMessage(Locale locale, String key, Object arg0) {
        return this.getMessage(locale, key, new Object[]{arg0});
    }

    public String getMessage(Locale locale, String key, Object arg0, Object arg1) {
        return this.getMessage(locale, key, new Object[]{arg0, arg1});
    }

    public String getMessage(Locale locale, String key, Object arg0, Object arg1, Object arg2) {
        return this.getMessage(locale, key, new Object[]{arg0, arg1, arg2});
    }

    public String getMessage(Locale locale, String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        return this.getMessage(locale, key, new Object[]{arg0, arg1, arg2, arg3});
    }

    public boolean isPresent(String key) {
        return this.isPresent(null, key);
    }

    public boolean isPresent(Locale locale, String key) {
        String message = this.getMessage(locale, key);
        if (message == null) {
            return false;
        }
        return !message.startsWith("???") || !message.endsWith("???");
    }

    protected String escape(String string) {
        if (!this.isEscape()) {
            return string;
        }
        if (string == null || string.indexOf(39) < 0) {
            return string;
        }
        int n = string.length();
        StringBuffer sb = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char ch = string.charAt(i);
            if (ch == '\'') {
                sb.append('\'');
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    protected String localeKey(Locale locale) {
        return locale == null ? "" : locale.toString();
    }

    protected String messageKey(Locale locale, String key) {
        return this.localeKey(locale) + "." + key;
    }

    protected String messageKey(String localeKey, String key) {
        return localeKey + "." + key;
    }

    public static synchronized MessageResources getMessageResources(String config) {
        if (defaultFactory == null) {
            defaultFactory = MessageResourcesFactory.createFactory();
        }
        return defaultFactory.createResources(config);
    }

    public void log(String message) {
        log.debug((Object)message);
    }

    public void log(String message, Throwable throwable) {
        log.debug((Object)message, throwable);
    }
}

