/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.ActionServletWrapper;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.FormFile;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.ModuleUtils;

public class RequestUtils {
    protected static Log log = LogFactory.getLog(RequestUtils.class);

    public static URL absoluteURL(HttpServletRequest request, String path) throws MalformedURLException {
        return new URL(RequestUtils.serverURL(request), request.getContextPath() + path);
    }

    public static Class applicationClass(String className) throws ClassNotFoundException {
        return RequestUtils.applicationClass(className, null);
    }

    public static Class applicationClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = RequestUtils.class.getClassLoader();
        }
        return classLoader.loadClass(className);
    }

    public static Object applicationInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return RequestUtils.applicationInstance(className, null);
    }

    public static Object applicationInstance(String className, ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return RequestUtils.applicationClass(className, classLoader).newInstance();
    }

    public static ActionForm createActionForm(HttpServletRequest request, ActionMapping mapping, ModuleConfig moduleConfig, ActionServlet servlet) {
        String attribute = mapping.getAttribute();
        if (attribute == null) {
            return null;
        }
        String name = mapping.getName();
        FormBeanConfig config = moduleConfig.findFormBeanConfig(name);
        if (config == null) {
            log.warn((Object)("No FormBeanConfig found under '" + name + "'"));
            return null;
        }
        ActionForm instance = RequestUtils.lookupActionForm(request, attribute, mapping.getScope());
        if (instance != null && config.canReuse(instance)) {
            return instance;
        }
        return RequestUtils.createActionForm(config, servlet);
    }

    private static ActionForm lookupActionForm(HttpServletRequest request, String attribute, String scope) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Looking for ActionForm bean instance in scope '" + scope + "' under attribute key '" + attribute + "'"));
        }
        ActionForm instance = null;
        HttpSession session = null;
        if ("request".equals(scope)) {
            instance = (ActionForm)request.getAttribute(attribute);
        } else {
            session = request.getSession();
            instance = (ActionForm)session.getAttribute(attribute);
        }
        return instance;
    }

    public static ActionForm createActionForm(FormBeanConfig config, ActionServlet servlet) {
        if (config == null) {
            return null;
        }
        ActionForm instance = null;
        try {
            instance = config.createActionForm(servlet);
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Creating new " + (config.getDynamic() ? "DynaActionForm" : "ActionForm") + " instance of type '" + config.getType() + "'"));
                log.trace((Object)(" --> " + instance));
            }
        }
        catch (Throwable t) {
            log.error((Object)servlet.getInternal().getMessage("formBean", (Object)config.getType()), t);
        }
        return instance;
    }

    public static String getServletMapping(ActionServlet servlet) {
        ServletContext servletContext = servlet.getServletConfig().getServletContext();
        return (String)servletContext.getAttribute("org.apache.struts.action.SERVLET_MAPPING");
    }

    public static Locale getUserLocale(HttpServletRequest request, String locale) {
        Locale userLocale = null;
        HttpSession session = request.getSession(false);
        if (locale == null) {
            locale = "org.apache.struts.action.LOCALE";
        }
        if (session != null) {
            userLocale = (Locale)session.getAttribute(locale);
        }
        if (userLocale == null) {
            userLocale = request.getLocale();
        }
        return userLocale;
    }

    public static void populate(Object bean, HttpServletRequest request) throws ServletException {
        RequestUtils.populate(bean, null, null, request);
    }

    public static void populate(Object bean, String prefix, String suffix, HttpServletRequest request) throws ServletException {
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        Enumeration names = null;
        Map multipartParameters = null;
        String contentType = request.getContentType();
        String method = request.getMethod();
        boolean isMultipart = false;
        if (bean instanceof ActionForm) {
            ((ActionForm)bean).setMultipartRequestHandler(null);
        }
        MultipartRequestHandler multipartHandler = null;
        if (contentType != null && contentType.startsWith("multipart/form-data") && method.equalsIgnoreCase("POST")) {
            if (!(bean instanceof ActionForm)) {
                throw new ServletException("bean that's supposed to be populated from a multipart request is not of type \"org.apache.struts.action.ActionForm\", but type \"" + bean.getClass().getName() + "\"");
            }
            ActionServletWrapper servlet = ((ActionForm)bean).getServletWrapper();
            multipartHandler = RequestUtils.getMultipartHandler(request);
            if (multipartHandler != null) {
                isMultipart = true;
                servlet.setServletFor(multipartHandler);
                multipartHandler.setMapping((ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance"));
                multipartHandler.handleRequest(request);
                Boolean maxLengthExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded");
                if (maxLengthExceeded != null && maxLengthExceeded.booleanValue()) {
                    ((ActionForm)bean).setMultipartRequestHandler(multipartHandler);
                    return;
                }
                multipartParameters = RequestUtils.getAllParametersForMultipartRequest(request, multipartHandler);
                names = Collections.enumeration(multipartParameters.keySet());
            }
        }
        if (!isMultipart) {
            names = request.getParameterNames();
        }
        while (names.hasMoreElements()) {
            String name;
            String stripped = name = (String)names.nextElement();
            if (prefix != null) {
                if (!stripped.startsWith(prefix)) continue;
                stripped = stripped.substring(prefix.length());
            }
            if (suffix != null) {
                if (!stripped.endsWith(suffix)) continue;
                stripped = stripped.substring(0, stripped.length() - suffix.length());
            }
            Object parameterValue = null;
            if (isMultipart) {
                parameterValue = multipartParameters.get(name);
                parameterValue = RequestUtils.rationalizeMultipleFileProperty(bean, name, parameterValue);
            } else {
                parameterValue = request.getParameterValues(name);
            }
            if (stripped.startsWith("org.apache.struts.")) continue;
            properties.put(stripped, (String[])parameterValue);
        }
        try {
            BeanUtils.populate((Object)bean, properties);
        }
        catch (Exception e) {
            throw new ServletException("BeanUtils.populate", (Throwable)e);
        }
        finally {
            if (multipartHandler != null) {
                ((ActionForm)bean).setMultipartRequestHandler(multipartHandler);
            }
        }
    }

    public static void populate(ActionRedirect redirect, HttpServletRequest request) {
        assert (redirect != null) : "redirect is required";
        assert (request != null) : "request is required";
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String[] values = request.getParameterValues(name);
            redirect.addParameter(name, values);
        }
    }

    private static Object rationalizeMultipleFileProperty(Object bean, String name, Object parameterValue) throws ServletException {
        if (!(parameterValue instanceof FormFile)) {
            return parameterValue;
        }
        FormFile formFileValue = (FormFile)parameterValue;
        try {
            Class propertyType = PropertyUtils.getPropertyType((Object)bean, (String)name);
            if (propertyType == null) {
                return parameterValue;
            }
            if (List.class.isAssignableFrom(propertyType)) {
                ArrayList<FormFile> list = new ArrayList<FormFile>(1);
                list.add(formFileValue);
                return list;
            }
            if (propertyType.isArray() && propertyType.getComponentType().equals(FormFile.class)) {
                return new FormFile[]{formFileValue};
            }
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServletException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServletException((Throwable)e);
        }
        return parameterValue;
    }

    private static MultipartRequestHandler getMultipartHandler(HttpServletRequest request) throws ServletException {
        ModuleConfig moduleConfig;
        MultipartRequestHandler multipartHandler = null;
        String multipartClass = (String)request.getAttribute("org.apache.struts.action.mapping.multipartclass");
        request.removeAttribute("org.apache.struts.action.mapping.multipartclass");
        if (multipartClass != null) {
            try {
                multipartHandler = (MultipartRequestHandler)RequestUtils.applicationInstance(multipartClass);
            }
            catch (ClassNotFoundException cnfe) {
                log.error((Object)("MultipartRequestHandler class \"" + multipartClass + "\" in mapping class not found, defaulting to global multipart class"));
            }
            catch (InstantiationException ie) {
                log.error((Object)("InstantiationException when instantiating MultipartRequestHandler \"" + multipartClass + "\", defaulting to global multipart class, exception: " + ie.getMessage()));
            }
            catch (IllegalAccessException iae) {
                log.error((Object)("IllegalAccessException when instantiating MultipartRequestHandler \"" + multipartClass + "\", defaulting to global multipart class, exception: " + iae.getMessage()));
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        if ((multipartClass = (moduleConfig = ModuleUtils.getInstance().getModuleConfig(request)).getControllerConfig().getMultipartClass()) != null) {
            try {
                multipartHandler = (MultipartRequestHandler)RequestUtils.applicationInstance(multipartClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServletException("Cannot find multipart class \"" + multipartClass + "\"", (Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new ServletException("InstantiationException when instantiating multipart class \"" + multipartClass + "\"", (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new ServletException("IllegalAccessException when instantiating multipart class \"" + multipartClass + "\"", (Throwable)iae);
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        return multipartHandler;
    }

    private static Map getAllParametersForMultipartRequest(HttpServletRequest request, MultipartRequestHandler multipartHandler) {
        String key;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Hashtable elements = multipartHandler.getAllElements();
        Enumeration e = elements.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            parameters.put(key, elements.get(key));
        }
        if (request instanceof MultipartRequestWrapper) {
            request = (HttpServletRequest)((MultipartRequestWrapper)request).getRequest();
            e = request.getParameterNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                parameters.put(key, request.getParameterValues(key));
            }
        } else {
            log.debug((Object)"Gathering multipart parameters for unwrapped request");
        }
        return parameters;
    }

    public static String printableURL(URL url) {
        if (url.getHost() != null) {
            return url.toString();
        }
        String file = url.getFile();
        String ref = url.getRef();
        if (ref == null) {
            return file;
        }
        StringBuffer sb = new StringBuffer(file);
        sb.append('#');
        sb.append(ref);
        return sb.toString();
    }

    public static String actionURL(HttpServletRequest request, ActionConfig action, String pattern) {
        StringBuffer sb = new StringBuffer();
        if (pattern.endsWith("/*")) {
            sb.append(pattern.substring(0, pattern.length() - 2));
            sb.append(action.getPath());
        } else if (pattern.startsWith("*.")) {
            ModuleConfig appConfig = ModuleUtils.getInstance().getModuleConfig(request);
            sb.append(appConfig.getPrefix());
            sb.append(action.getPath());
            sb.append(pattern.substring(1));
        } else {
            throw new IllegalArgumentException(pattern);
        }
        return sb.toString();
    }

    public static String forwardURL(HttpServletRequest request, ForwardConfig forward) {
        return RequestUtils.forwardURL(request, forward, null);
    }

    public static String forwardURL(HttpServletRequest request, ForwardConfig forward, ModuleConfig moduleConfig) {
        if (moduleConfig == null) {
            moduleConfig = ModuleUtils.getInstance().getModuleConfig(request);
        }
        String path = forward.getPath();
        String prefix = moduleConfig.getPrefix();
        if (forward.getModule() != null && "/".equals(prefix = forward.getModule())) {
            prefix = "";
        }
        StringBuffer sb = new StringBuffer();
        String forwardPattern = moduleConfig.getControllerConfig().getForwardPattern();
        if (forwardPattern == null) {
            sb.append(prefix);
            if (!path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
        } else {
            boolean dollar = false;
            for (int i = 0; i < forwardPattern.length(); ++i) {
                char ch = forwardPattern.charAt(i);
                if (dollar) {
                    switch (ch) {
                        case 'M': {
                            sb.append(prefix);
                            break;
                        }
                        case 'P': {
                            if (!path.startsWith("/")) {
                                sb.append("/");
                            }
                            sb.append(path);
                            break;
                        }
                        case '$': {
                            sb.append('$');
                            break;
                        }
                    }
                    dollar = false;
                    continue;
                }
                if (ch == '$') {
                    dollar = true;
                    continue;
                }
                sb.append(ch);
            }
        }
        return sb.toString();
    }

    public static URL requestURL(HttpServletRequest request) throws MalformedURLException {
        StringBuffer url = RequestUtils.requestToServerUriStringBuffer(request);
        return new URL(url.toString());
    }

    public static URL serverURL(HttpServletRequest request) throws MalformedURLException {
        StringBuffer url = RequestUtils.requestToServerStringBuffer(request);
        return new URL(url.toString());
    }

    public static StringBuffer requestToServerUriStringBuffer(HttpServletRequest request) {
        StringBuffer serverUri = RequestUtils.createServerUriStringBuffer(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRequestURI());
        return serverUri;
    }

    public static StringBuffer requestToServerStringBuffer(HttpServletRequest request) {
        return RequestUtils.createServerStringBuffer(request.getScheme(), request.getServerName(), request.getServerPort());
    }

    public static StringBuffer createServerStringBuffer(String scheme, String server, int port) {
        StringBuffer url = new StringBuffer();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(server);
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        return url;
    }

    public static StringBuffer createServerUriStringBuffer(String scheme, String server, int port, String uri) {
        StringBuffer serverUri = RequestUtils.createServerStringBuffer(scheme, server, port);
        serverUri.append(uri);
        return serverUri;
    }

    public static String actionIdURL(ForwardConfig forward, HttpServletRequest request, ActionServlet servlet) {
        ModuleConfig moduleConfig = null;
        if (forward.getModule() != null) {
            String prefix = forward.getModule();
            moduleConfig = ModuleUtils.getInstance().getModuleConfig(prefix, servlet.getServletContext());
        } else {
            moduleConfig = ModuleUtils.getInstance().getModuleConfig(request);
        }
        return RequestUtils.actionIdURL(forward.getPath(), moduleConfig, servlet);
    }

    public static String actionIdURL(String originalPath, ModuleConfig moduleConfig, ActionServlet servlet) {
        if (originalPath.startsWith("http") || originalPath.startsWith("/")) {
            return null;
        }
        String actionId = null;
        String qs = null;
        int qpos = originalPath.indexOf("?");
        if (qpos == -1) {
            actionId = originalPath;
        } else {
            actionId = originalPath.substring(0, qpos);
            qs = originalPath.substring(qpos);
        }
        ActionConfig actionConfig = moduleConfig.findActionConfigId(actionId);
        if (actionConfig == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No actionId found for " + actionId));
            }
            return null;
        }
        String path = actionConfig.getPath();
        String mapping = RequestUtils.getServletMapping(servlet);
        StringBuffer actionIdPath = new StringBuffer();
        if (mapping.startsWith("*")) {
            actionIdPath.append(path);
            actionIdPath.append(mapping.substring(1));
        } else if (mapping.startsWith("/")) {
            if ((mapping = mapping.substring(0, mapping.length() - 1)).endsWith("/") && path.startsWith("/")) {
                actionIdPath.append(mapping);
                actionIdPath.append(path.substring(1));
            } else {
                actionIdPath.append(mapping);
                actionIdPath.append(path);
            }
        } else {
            log.warn((Object)"Unknown servlet mapping pattern");
            actionIdPath.append(path);
        }
        if (qs != null) {
            actionIdPath.append(qs);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(originalPath + " unaliased to " + actionIdPath.toString()));
        }
        return actionIdPath.toString();
    }

    public static boolean isRequestForwarded(HttpServletRequest request) {
        return request.getAttribute("javax.servlet.forward.request_uri") != null;
    }

    public static boolean isRequestIncluded(HttpServletRequest request) {
        return request.getAttribute("javax.servlet.include.request_uri") != null;
    }

    public static boolean isRequestChained(HttpServletRequest request) {
        return request.getAttribute("org.apache.struts.action.CHAIN") != null;
    }
}

