/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.UrlValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.validator.Resources;

public class FieldChecks
implements Serializable {
    private static final Log log = LogFactory.getLog(FieldChecks.class);
    private static MessageResources sysmsgs = MessageResources.getMessageResources("org.apache.struts.validator.LocalStrings");
    public static final String FIELD_TEST_NULL = "NULL";
    public static final String FIELD_TEST_NOTNULL = "NOTNULL";
    public static final String FIELD_TEST_EQUAL = "EQUAL";

    private static String getValueAsString(Object bean, String property) throws Exception {
        Object value = PropertyUtils.getProperty((Object)bean, (String)property);
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return ((String[])value).length > 0 ? value.toString() : "";
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty() ? "" : value.toString();
        }
        return value.toString();
    }

    public static boolean validateRequired(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "required", e);
            return false;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateRequiredIf(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Object form = validator.getParameterValue("java.lang.Object");
        String value = null;
        boolean required = false;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "requiredif", e);
            return false;
        }
        int i = 0;
        String fieldJoin = "AND";
        if (!GenericValidator.isBlankOrNull((String)field.getVarValue("fieldJoin"))) {
            fieldJoin = field.getVarValue("fieldJoin");
        }
        if (fieldJoin.equalsIgnoreCase("AND")) {
            required = true;
        }
        while (!GenericValidator.isBlankOrNull((String)field.getVarValue("field[" + i + "]"))) {
            String key;
            String dependProp = field.getVarValue("field[" + i + "]");
            String dependTest = field.getVarValue("fieldTest[" + i + "]");
            String dependTestValue = field.getVarValue("fieldValue[" + i + "]");
            String dependIndexed = field.getVarValue("fieldIndexed[" + i + "]");
            if (dependIndexed == null) {
                dependIndexed = "false";
            }
            String dependVal = null;
            boolean thisRequired = false;
            if (field.isIndexed() && dependIndexed.equalsIgnoreCase("true") && (key = field.getKey()).indexOf("[") > -1 && key.indexOf("]") > -1) {
                String ind = key.substring(0, key.indexOf(".") + 1);
                dependProp = ind + dependProp;
            }
            dependVal = ValidatorUtils.getValueAsString((Object)form, (String)dependProp);
            if (dependTest.equals(FIELD_TEST_NULL)) {
                thisRequired = dependVal == null || dependVal.length() <= 0;
            }
            if (dependTest.equals(FIELD_TEST_NOTNULL)) {
                thisRequired = dependVal != null && dependVal.length() > 0;
            }
            if (dependTest.equals(FIELD_TEST_EQUAL)) {
                thisRequired = dependTestValue.equalsIgnoreCase(dependVal);
            }
            required = fieldJoin.equalsIgnoreCase("AND") ? required && thisRequired : required || thisRequired;
            ++i;
        }
        if (required) {
            if (GenericValidator.isBlankOrNull((String)value)) {
                errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateMask(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
            String mask = Resources.getVarValue("mask", field, validator, request, true);
            if (value != null && value.length() > 0 && !GenericValidator.matchRegexp((String)value, (String)mask)) {
                errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "mask", e);
            return false;
        }
    }

    public static Object validateByte(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Byte result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "byte", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatByte((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateByteLocale(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Byte result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "byteLocale", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        result = GenericTypeValidator.formatByte((String)value, (Locale)locale);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    private static String evaluateBean(Object bean, Field field) throws Exception {
        String value = FieldChecks.isString(bean) ? (String)bean : FieldChecks.getValueAsString(bean, field.getProperty());
        return value;
    }

    public static Object validateShort(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Short result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "short", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatShort((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateShortLocale(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Short result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "shortLocale", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        result = GenericTypeValidator.formatShort((String)value, (Locale)locale);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateInteger(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Integer result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "integer", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatInt((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateIntegerLocale(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Integer result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "integerLocale", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        result = GenericTypeValidator.formatInt((String)value, (Locale)locale);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateLong(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Long result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "long", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatLong((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateLongLocale(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Long result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "longLocale", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        result = GenericTypeValidator.formatLong((String)value, (Locale)locale);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateFloat(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Float result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "float", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatFloat((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateFloatLocale(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Float result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "floatLocale", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        result = GenericTypeValidator.formatFloat((String)value, (Locale)locale);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateDouble(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Double result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "double", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatDouble((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateDoubleLocale(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Double result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "doubleLocale", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        result = GenericTypeValidator.formatDouble((String)value, (Locale)locale);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static Object validateDate(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Date result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "date", e);
            return Boolean.FALSE;
        }
        boolean isStrict = false;
        String datePattern = Resources.getVarValue("datePattern", field, validator, request, false);
        if (GenericValidator.isBlankOrNull((String)datePattern) && !GenericValidator.isBlankOrNull((String)(datePattern = Resources.getVarValue("datePatternStrict", field, validator, request, false)))) {
            isStrict = true;
        }
        Locale locale = RequestUtils.getUserLocale(request, null);
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        try {
            result = GenericValidator.isBlankOrNull((String)datePattern) ? GenericTypeValidator.formatDate((String)value, (Locale)locale) : GenericTypeValidator.formatDate((String)value, (String)datePattern, (boolean)isStrict);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? Boolean.FALSE : result;
    }

    public static boolean validateLongRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
            if (!GenericValidator.isBlankOrNull((String)value)) {
                long max;
                String minVar = Resources.getVarValue("min", field, validator, request, true);
                String maxVar = Resources.getVarValue("max", field, validator, request, true);
                long longValue = Long.parseLong(value);
                long min = Long.parseLong(minVar);
                if (min > (max = Long.parseLong(maxVar))) {
                    throw new IllegalArgumentException(sysmsgs.getMessage("invalid.range", (Object)minVar, (Object)maxVar));
                }
                if (!GenericValidator.isInRange((long)longValue, (long)min, (long)max)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "longRange", e);
            return false;
        }
        return true;
    }

    public static boolean validateIntRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
            if (!GenericValidator.isBlankOrNull((String)value)) {
                String minVar = Resources.getVarValue("min", field, validator, request, true);
                String maxVar = Resources.getVarValue("max", field, validator, request, true);
                int min = Integer.parseInt(minVar);
                int max = Integer.parseInt(maxVar);
                int intValue = Integer.parseInt(value);
                if (min > max) {
                    throw new IllegalArgumentException(sysmsgs.getMessage("invalid.range", (Object)minVar, (Object)maxVar));
                }
                if (!GenericValidator.isInRange((int)intValue, (int)min, (int)max)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "intRange", e);
            return false;
        }
        return true;
    }

    public static boolean validateDoubleRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
            if (!GenericValidator.isBlankOrNull((String)value)) {
                double max;
                String minVar = Resources.getVarValue("min", field, validator, request, true);
                String maxVar = Resources.getVarValue("max", field, validator, request, true);
                double doubleValue = Double.parseDouble(value);
                double min = Double.parseDouble(minVar);
                if (min > (max = Double.parseDouble(maxVar))) {
                    throw new IllegalArgumentException(sysmsgs.getMessage("invalid.range", (Object)minVar, (Object)maxVar));
                }
                if (!GenericValidator.isInRange((double)doubleValue, (double)min, (double)max)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "doubleRange", e);
            return false;
        }
        return true;
    }

    public static boolean validateFloatRange(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
            if (!GenericValidator.isBlankOrNull((String)value)) {
                float max;
                String minVar = Resources.getVarValue("min", field, validator, request, true);
                String maxVar = Resources.getVarValue("max", field, validator, request, true);
                float floatValue = Float.parseFloat(value);
                float min = Float.parseFloat(minVar);
                if (min > (max = Float.parseFloat(maxVar))) {
                    throw new IllegalArgumentException(sysmsgs.getMessage("invalid.range", (Object)minVar, (Object)maxVar));
                }
                if (!GenericValidator.isInRange((float)floatValue, (float)min, (float)max)) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "floatRange", e);
            return false;
        }
        return true;
    }

    public static Object validateCreditCard(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Long result = null;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "creditCard", e);
            return Boolean.FALSE;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatCreditCard((String)value);
        if (result == null) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        }
        return result == null ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)result;
    }

    public static boolean validateEmail(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "email", e);
            return false;
        }
        if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.isEmail((String)value)) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateMaxLength(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
            if (value != null) {
                String maxVar = Resources.getVarValue("maxlength", field, validator, request, true);
                int max = Integer.parseInt(maxVar);
                boolean isValid = false;
                String endLth = Resources.getVarValue("lineEndLength", field, validator, request, false);
                isValid = GenericValidator.isBlankOrNull((String)endLth) ? GenericValidator.maxLength((String)value, (int)max) : GenericValidator.maxLength((String)value, (int)max, (int)Integer.parseInt(endLth));
                if (!isValid) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "maxlength", e);
            return false;
        }
        return true;
    }

    public static boolean validateMinLength(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
            if (!GenericValidator.isBlankOrNull((String)value)) {
                String minVar = Resources.getVarValue("minlength", field, validator, request, true);
                int min = Integer.parseInt(minVar);
                boolean isValid = false;
                String endLth = Resources.getVarValue("lineEndLength", field, validator, request, false);
                isValid = GenericValidator.isBlankOrNull((String)endLth) ? GenericValidator.minLength((String)value, (int)min) : GenericValidator.minLength((String)value, (int)min, (int)Integer.parseInt(endLth));
                if (!isValid) {
                    errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
                    return false;
                }
            }
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "minlength", e);
            return false;
        }
        return true;
    }

    public static boolean validateUrl(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        UrlValidator urlValidator;
        String schemesVar;
        String nofragmentsVar;
        String value = null;
        try {
            value = FieldChecks.evaluateBean(bean, field);
        }
        catch (Exception e) {
            FieldChecks.processFailure(errors, field, validator.getFormName(), "url", e);
            return false;
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return true;
        }
        String allowallschemesVar = Resources.getVarValue("allowallschemes", field, validator, request, false);
        boolean allowallschemes = "true".equalsIgnoreCase(allowallschemesVar);
        int options = allowallschemes ? 1 : 0;
        String allow2slashesVar = Resources.getVarValue("allow2slashes", field, validator, request, false);
        if ("true".equalsIgnoreCase(allow2slashesVar)) {
            options += 2;
        }
        if ("true".equalsIgnoreCase(nofragmentsVar = Resources.getVarValue("nofragments", field, validator, request, false))) {
            options += 4;
        }
        String string = schemesVar = allowallschemes ? null : Resources.getVarValue("schemes", field, validator, request, false);
        if (options == 0 && schemesVar == null) {
            if (GenericValidator.isUrl((String)value)) {
                return true;
            }
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
            return false;
        }
        String[] schemes = null;
        if (schemesVar != null) {
            StringTokenizer st = new StringTokenizer(schemesVar, ",");
            schemes = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                schemes[i++] = st.nextToken().trim();
            }
        }
        if ((urlValidator = new UrlValidator(schemes, options)).isValid(value)) {
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
        return false;
    }

    private static void processFailure(ActionMessages errors, Field field, String formName, String validatorName, Throwable t) {
        String logErrorMsg = sysmsgs.getMessage("validation.failed", (Object)validatorName, (Object)field.getProperty(), (Object)formName, (Object)t.toString());
        log.error((Object)logErrorMsg, t);
        String userErrorMsg = sysmsgs.getMessage("system.error");
        errors.add(field.getKey(), new ActionMessage(userErrorMsg, false));
    }

    protected static boolean isString(Object o) {
        return o == null ? true : String.class.isInstance(o);
    }
}

