/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.actions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.BaseAction;

public abstract class DispatchAction
extends BaseAction {
    protected static Log log = LogFactory.getLog(DispatchAction.class);
    protected Class clazz = ((Object)((Object)this)).getClass();
    protected HashMap methods = new HashMap();
    protected Class[] types = new Class[]{ActionMapping.class, ActionForm.class, HttpServletRequest.class, HttpServletResponse.class};

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward af;
        if (this.isCancelled(request) && (af = this.cancelled(mapping, form, request, response)) != null) {
            return af;
        }
        String parameter = this.getParameter(mapping, form, request, response);
        String name = this.getMethodName(mapping, form, request, response, parameter);
        if ("execute".equals(name) || "perform".equals(name)) {
            String message = messages.getMessage("dispatch.recursive", (Object)mapping.getPath());
            log.error((Object)message);
            throw new ServletException(message);
        }
        return this.dispatchMethod(mapping, form, request, response, name);
    }

    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = messages.getMessage("dispatch.parameter", (Object)mapping.getPath(), (Object)mapping.getParameter());
        log.error((Object)message);
        throw new ServletException(message);
    }

    protected ActionForward cancelled(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    protected ActionForward dispatchMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String name) throws Exception {
        if (name == null) {
            return this.unspecified(mapping, form, request, response);
        }
        Method method = null;
        try {
            method = this.getMethod(name);
        }
        catch (NoSuchMethodException e) {
            String message = messages.getMessage("dispatch.method", (Object)mapping.getPath(), (Object)name);
            log.error((Object)message, (Throwable)e);
            String userMsg = messages.getMessage("dispatch.method.user", (Object)mapping.getPath());
            NoSuchMethodException e2 = new NoSuchMethodException(userMsg);
            e2.initCause(e);
            throw e2;
        }
        ActionForward forward = null;
        try {
            Object[] args = new Object[]{mapping, form, request, response};
            forward = (ActionForward)method.invoke((Object)this, args);
        }
        catch (ClassCastException e) {
            String message = messages.getMessage("dispatch.return", (Object)mapping.getPath(), (Object)name);
            log.error((Object)message, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            String message = messages.getMessage("dispatch.error", (Object)mapping.getPath(), (Object)name);
            log.error((Object)message, (Throwable)e);
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            String message = messages.getMessage("dispatch.error", (Object)mapping.getPath(), (Object)name);
            log.error((Object)message, (Throwable)e);
            throw new ServletException(t);
        }
        return forward;
    }

    protected String getParameter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parameter = mapping.getParameter();
        if (parameter == null) {
            String message = messages.getMessage("dispatch.handler", (Object)mapping.getPath());
            log.error((Object)message);
            throw new ServletException(message);
        }
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Method getMethod(String name) throws NoSuchMethodException {
        HashMap hashMap = this.methods;
        synchronized (hashMap) {
            Method method = (Method)this.methods.get(name);
            if (method == null) {
                method = this.clazz.getMethod(name, this.types);
                this.methods.put(name, method);
            }
            return method;
        }
    }

    protected String getMethodName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String parameter) throws Exception {
        return request.getParameter(parameter);
    }
}

