/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.plugins;

import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;
import org.apache.struts.util.RequestUtils;

public class ModuleConfigVerifier
implements PlugIn {
    private static Log LOG = LogFactory.getLog(ModuleConfigVerifier.class);
    protected ModuleConfig config = null;
    protected ActionServlet servlet = null;
    private boolean fatal = true;

    public boolean isFatal() {
        return this.fatal;
    }

    public void setFatal(boolean fatal) {
        this.fatal = fatal;
    }

    public void destroy() {
    }

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.servlet = servlet;
        this.config = config;
        boolean ok = true;
        LOG.info((Object)servlet.getInternal().getMessage("configVerifying"));
        if (!this.verifyActionMappingClass()) {
            ok = false;
        }
        if (!this.verifyForwardConfigs()) {
            ok = false;
        }
        if (!this.verifyMessageResourcesConfigs()) {
            ok = false;
        }
        if (!this.verifyPlugInConfigs()) {
            ok = false;
        }
        LOG.info((Object)servlet.getInternal().getMessage("configCompleted"));
        if (!ok && this.isFatal()) {
            throw new ServletException(servlet.getInternal().getMessage("configFatal"));
        }
    }

    protected boolean verifyActionMappingClass() {
        String amcName = this.config.getActionMappingClass();
        if (amcName == null) {
            LOG.error((Object)this.servlet.getInternal().getMessage("verifyActionMappingClass.missing"));
            return false;
        }
        try {
            Class clazz = RequestUtils.applicationClass((String)amcName);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)this.servlet.getInternal().getMessage("verifyActionMappingClass.invalid", (Object)amcName));
            return false;
        }
        return true;
    }

    protected boolean verifyForwardConfigs() {
        boolean ok = true;
        ForwardConfig[] fcs = this.config.findForwardConfigs();
        for (int i = 0; i < fcs.length; ++i) {
            String path = fcs[i].getPath();
            if (path == null) {
                LOG.error((Object)this.servlet.getInternal().getMessage("verifyForwardConfigs.missing", (Object)fcs[i].getName()));
                ok = false;
                continue;
            }
            if (path.startsWith("/")) continue;
            LOG.error((Object)this.servlet.getInternal().getMessage("verifyForwardConfigs.invalid", (Object)path, (Object)fcs[i].getName()));
        }
        return ok;
    }

    protected boolean verifyMessageResourcesConfigs() {
        boolean ok = true;
        MessageResourcesConfig[] mrcs = this.config.findMessageResourcesConfigs();
        for (int i = 0; i < mrcs.length; ++i) {
            String factory = mrcs[i].getFactory();
            if (factory == null) {
                LOG.error((Object)this.servlet.getInternal().getMessage("verifyMessageResourcesConfigs.missing"));
                ok = false;
            } else {
                try {
                    Class clazz = RequestUtils.applicationClass((String)factory);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)this.servlet.getInternal().getMessage("verifyMessageResourcesConfigs.invalid", (Object)factory));
                    ok = false;
                }
            }
            String key = mrcs[i].getKey();
            if (key != null) continue;
            LOG.error((Object)this.servlet.getInternal().getMessage("verifyMessageResourcesConfigs.key"));
        }
        return ok;
    }

    protected boolean verifyPlugInConfigs() {
        boolean ok = true;
        PlugInConfig[] pics = this.config.findPlugInConfigs();
        for (int i = 0; i < pics.length; ++i) {
            String className = pics[i].getClassName();
            if (className == null) {
                LOG.error((Object)this.servlet.getInternal().getMessage("verifyPlugInConfigs.missing"));
                ok = false;
                continue;
            }
            try {
                Class clazz = RequestUtils.applicationClass((String)className);
                continue;
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)this.servlet.getInternal().getMessage("verifyPlugInConfigs.invalid", (Object)className));
                ok = false;
            }
        }
        return ok;
    }
}

