/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.application;

import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.faces.component.FormComponent;
import org.apache.struts.util.ModuleUtils;
import org.apache.struts.util.RequestUtils;

public final class ActionListenerImpl
implements ActionListener {
    private static final Log log = LogFactory.getLog(ActionListenerImpl.class);
    private ActionListener original;

    public ActionListenerImpl(ActionListener original) {
        if (original == null) {
            throw new NullPointerException();
        }
        this.original = original;
        if (log.isInfoEnabled()) {
            log.info((Object)("Create ActionListener wrapping instance of type '" + original.getClass().getName() + "'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        ActionSource source = (ActionSource)component;
        boolean standard = source.isImmediate();
        if (!standard) {
            for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof UIForm)) continue;
                if (parent instanceof FormComponent) break;
                standard = true;
                break;
            }
        }
        if (standard) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Performing standard handling for event from source component '" + component.getId() + "'"));
            }
            this.original.processAction(event);
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ServletContext servletContext = (ServletContext)context.getExternalContext().getContext();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Performing Struts form submit for event  from source component '" + component.getId() + "'"));
        }
        try {
            request.setAttribute("org.apache.struts.faces.ACTION_EVENT", (Object)event);
            ModuleUtils.getInstance().selectModule(request, servletContext);
            ModuleConfig moduleConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
            if (log.isTraceEnabled()) {
                log.trace((Object)("Assigned to module with prefix '" + moduleConfig.getPrefix() + "'"));
            }
            RequestProcessor processor = this.getRequestProcessor(moduleConfig, servletContext);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Invoking request processor instance " + processor));
            }
            processor.process(request, response);
            context.responseComplete();
        }
        catch (Exception e) {
            log.error((Object)("Exception processing action event " + event), (Throwable)e);
        }
        finally {
            request.removeAttribute("org.apache.struts.faces.ACTION_EVENT");
        }
    }

    protected RequestProcessor getRequestProcessor(ModuleConfig config, ServletContext context) {
        String key = "org.apache.struts.action.REQUEST_PROCESSOR" + config.getPrefix();
        RequestProcessor processor = (RequestProcessor)context.getAttribute(key);
        if (processor == null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Instantiating RequestProcessor of class " + config.getControllerConfig().getProcessorClass()));
                }
                ActionServlet servlet = (ActionServlet)context.getAttribute("org.apache.struts.action.ACTION_SERVLET");
                processor = (RequestProcessor)RequestUtils.applicationInstance((String)config.getControllerConfig().getProcessorClass());
                processor.init(servlet, config);
                context.setAttribute(key, (Object)processor);
            }
            catch (Exception e) {
                log.error((Object)("Cannot instantiate RequestProcessor of class " + config.getControllerConfig().getProcessorClass()), (Throwable)e);
                IllegalStateException e2 = new IllegalStateException("Cannot initialize RequestProcessor of class " + config.getControllerConfig().getProcessorClass());
                e2.initCause(e);
                throw e2;
            }
        }
        return processor;
    }
}

