/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.application;

import java.util.Map;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.DynaActionForm;

public class PropertyResolverImpl
extends PropertyResolver {
    private static final Log log = LogFactory.getLog(PropertyResolverImpl.class);
    private PropertyResolver resolver = null;

    public PropertyResolverImpl(PropertyResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating new instance, wrapping resolver " + resolver));
        }
        this.resolver = resolver;
    }

    public Object getValue(Object base, Object name) throws PropertyNotFoundException {
        if (base == null || name == null) {
            throw new NullPointerException();
        }
        if (base instanceof DynaActionForm && "map".equals(name)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Returning property map for DynaActionForm " + base + "'"));
            }
            return ((DynaActionForm)base).getMap();
        }
        if (base instanceof DynaBean) {
            if (this.getDynaProperty((DynaBean)base, name.toString()) == null) {
                throw new PropertyNotFoundException(name.toString());
            }
            Object value = ((DynaBean)base).get(name.toString());
            if (log.isTraceEnabled()) {
                log.trace((Object)("Returning dynamic property '" + name + "' for DynaBean '" + base + "' value '" + value + "'"));
            }
            return value;
        }
        Object value = this.resolver.getValue(base, name);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Delegating get of property '" + name + "' for bean '" + base + "' value '" + value + "'"));
        }
        return value;
    }

    public Object getValue(Object base, int index) throws PropertyNotFoundException {
        return this.resolver.getValue(base, index);
    }

    public void setValue(Object base, Object name, Object value) throws PropertyNotFoundException {
        if (base == null || name == null) {
            throw new NullPointerException();
        }
        if (base instanceof DynaActionForm && "map".equals(name)) {
            throw new PropertyNotFoundException(name.toString());
        }
        if (base instanceof DynaBean) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("setting dynamic property '" + name + "' for DynaBean '" + base + "' to '" + value + "'"));
            }
            if (this.getDynaProperty((DynaBean)base, name.toString()) == null) {
                throw new PropertyNotFoundException(name.toString());
            }
            ((DynaBean)base).set(name.toString(), value);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Delegating set of property '" + name + "' for bean '" + base + "' to value '" + value + "'"));
            }
            this.resolver.setValue(base, name, value);
        }
    }

    public void setValue(Object base, int index, Object value) throws PropertyNotFoundException {
        this.resolver.setValue(base, index, value);
    }

    public boolean isReadOnly(Object base, Object name) throws PropertyNotFoundException {
        if (base == null || name == null) {
            throw new NullPointerException();
        }
        if (base instanceof DynaActionForm && "map".equals(name)) {
            return true;
        }
        if (base instanceof DynaBean) {
            if (this.getDynaProperty((DynaBean)base, name.toString()) == null) {
                throw new PropertyNotFoundException(name.toString());
            }
            return false;
        }
        return this.resolver.isReadOnly(base, (Object)name.toString());
    }

    public boolean isReadOnly(Object base, int index) throws PropertyNotFoundException {
        return this.resolver.isReadOnly(base, index);
    }

    public Class getType(Object base, Object name) throws PropertyNotFoundException {
        if (base == null || name == null) {
            throw new NullPointerException();
        }
        if (base instanceof DynaActionForm && "map".equals(name)) {
            return Map.class;
        }
        if (base instanceof DynaBean) {
            DynaProperty dynaProperty = this.getDynaProperty((DynaBean)base, name.toString());
            if (dynaProperty != null) {
                return dynaProperty.getType();
            }
            throw new PropertyNotFoundException(name.toString());
        }
        return this.resolver.getType(base, name);
    }

    public Class getType(Object base, int index) throws PropertyNotFoundException {
        return this.resolver.getType(base, index);
    }

    private DynaProperty getDynaProperty(DynaBean bean, String name) throws PropertyNotFoundException {
        DynaProperty dynaProperty = null;
        try {
            dynaProperty = bean.getDynaClass().getDynaProperty(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return dynaProperty;
    }
}

