/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRenderer
extends Renderer {
    private static final Log log = LogFactory.getLog(AbstractRenderer.class);

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        if (component instanceof EditableValueHolder) {
            this.setSubmittedValue(context, component);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("encodeBegin(id=" + component.getId() + ", family=" + component.getFamily() + ", rendererType=" + component.getRendererType() + ")"));
        }
        ResponseWriter writer = context.getResponseWriter();
        this.renderStart(context, component, writer);
        this.renderAttributes(context, component, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("encodeChildren(id=" + component.getId() + ", family=" + component.getFamily() + ", rendererType=" + component.getRendererType() + ")"));
        }
        for (UIComponent kid : component.getChildren()) {
            kid.encodeBegin(context);
            if (kid.getRendersChildren()) {
                kid.encodeChildren(context);
            }
            kid.encodeEnd(context);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("encodeChildren(id=" + component.getId() + ") end"));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("encodeEnd(id=" + component.getId() + ", family=" + component.getFamily() + ", rendererType=" + component.getRendererType() + ")"));
        }
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnd(context, component, writer);
    }

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("encodeRecursive(id=" + component.getId() + ", family=" + component.getFamily() + ", rendererType=" + component.getRendererType() + ") encodeBegin"));
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("encodeRecursive(id=" + component.getId() + ") delegating"));
            }
            component.encodeChildren(context);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("encodeRecursive(id=" + component.getId() + ") recursing"));
            }
            for (UIComponent kid : component.getChildren()) {
                this.encodeRecursive(context, kid);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("encodeRecursive(id=" + component.getId() + ") encodeEnd"));
        }
        component.encodeEnd(context);
    }

    protected boolean isDisabled(UIComponent component) {
        Object disabled = component.getAttributes().get("disabled");
        if (disabled == null) {
            return false;
        }
        if (disabled instanceof String) {
            return Boolean.valueOf((String)disabled);
        }
        return disabled.equals(Boolean.TRUE);
    }

    protected boolean isReadOnly(UIComponent component) {
        Object readonly = component.getAttributes().get("readonly");
        if (readonly == null) {
            return false;
        }
        if (readonly instanceof String) {
            return Boolean.valueOf((String)readonly);
        }
        return readonly.equals(Boolean.TRUE);
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void renderBoolean(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (int i = 0; i < names.length; ++i) {
            boolean flag;
            Object value = attributes.get(names[i]);
            if (value == null || !(flag = value instanceof String ? Boolean.valueOf((String)value).booleanValue() : Boolean.valueOf(value.toString()).booleanValue())) continue;
            writer.writeAttribute(names[i], (Object)names[i], names[i]);
            flag = false;
        }
    }

    protected void renderPassThrough(FacesContext context, UIComponent component, ResponseWriter writer, String[] names) throws IOException {
        if (names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (int i = 0; i < names.length; ++i) {
            Object value = attributes.get(names[i]);
            if (value == null) continue;
            if (value instanceof String) {
                writer.writeAttribute(names[i], value, names[i]);
                continue;
            }
            writer.writeAttribute(names[i], (Object)value.toString(), names[i]);
        }
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    protected void setSubmittedValue(FacesContext context, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map parameters = context.getExternalContext().getRequestParameterMap();
        if (parameters.containsKey(clientId)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("setSubmittedValue(" + clientId + "," + (String)parameters.get(clientId)));
            }
            component.getAttributes().put("submittedValue", parameters.get(clientId));
        }
    }

    protected String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        Class type;
        ValueBinding vb = component.getValueBinding("value");
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null && vb != null && (type = vb.getType(context)) != null) {
            converter = context.getApplication().createConverter(type);
        }
        if (converter != null) {
            return converter.getAsString(context, component, value);
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }
}

