/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.faces.renderer.AbstractRenderer;

public class BaseRenderer
extends AbstractRenderer {
    private static Log log = LogFactory.getLog(BaseRenderer.class);

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("viewId='" + context.getViewRoot().getViewId() + "' --> uri='" + this.uri(context) + "'"));
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("base", component);
        writer.writeURIAttribute("href", (Object)this.uri(context), null);
        String target = (String)component.getAttributes().get("target");
        if (target != null) {
            writer.writeAttribute("target", (Object)target, "target");
        }
        writer.endElement("base");
        writer.writeText((Object)"\n", null);
    }

    protected boolean isPortletRequest(FacesContext context) {
        Object request = context.getExternalContext().getRequest();
        for (Class<?> clazz = request.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces == null) {
                interfaces = new Class[]{};
            }
            for (int i = 0; i < interfaces.length; ++i) {
                if (!"javax.portlet.PortletRequest".equals(interfaces[i].getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isServletRequest(FacesContext context) {
        Object request = context.getExternalContext().getRequest();
        return request instanceof HttpServletRequest;
    }

    protected String portletUri(FacesContext context) {
        Object request = context.getExternalContext().getRequest();
        try {
            String scheme = (String)MethodUtils.invokeMethod((Object)request, (String)"getScheme", null);
            StringBuffer sb = new StringBuffer(scheme);
            sb.append("://");
            sb.append(MethodUtils.invokeMethod((Object)request, (String)"getServerName", null));
            Integer port = (Integer)MethodUtils.invokeMethod((Object)request, (String)"getServerPort", null);
            if (!("http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443)) {
                sb.append(":" + port);
            }
            sb.append(MethodUtils.invokeMethod((Object)request, (String)"getContextPath", null));
            sb.append(context.getViewRoot().getViewId());
            return sb.toString();
        }
        catch (InvocationTargetException e) {
            throw new FacesException(e.getTargetException());
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    protected String servletUri(FacesContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        StringBuffer sb = new StringBuffer(request.getScheme());
        sb.append("://");
        sb.append(request.getServerName());
        if (!("http".equals(request.getScheme()) && 80 == request.getServerPort() || "https".equals(request.getScheme()) && 443 == request.getServerPort())) {
            sb.append(":" + request.getServerPort());
        }
        sb.append(request.getContextPath());
        sb.append(context.getViewRoot().getViewId());
        return sb.toString();
    }

    protected String uri(FacesContext context) {
        if (this.isServletRequest(context)) {
            return this.servletUri(context);
        }
        if (this.isPortletRequest(context)) {
            return this.portletUri(context);
        }
        throw new IllegalArgumentException("Request is neither HttpServletRequest nor PortletRequest");
    }
}

