/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.faces.component.FormComponent;
import org.apache.struts.faces.renderer.AbstractRenderer;

public class FormRenderer
extends AbstractRenderer {
    private static Log log = LogFactory.getLog(FormRenderer.class);
    private static String[] passThrough = new String[]{"enctype", "method", "onreset", "onsubmit", "style", "target"};

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String clientId = component.getClientId(context);
        Map map = context.getExternalContext().getRequestParameterMap();
        if (log.isDebugEnabled()) {
            log.debug((Object)("decode(" + clientId + ") --> " + map.containsKey(clientId)));
        }
        component.getAttributes().put("submitted", map.containsKey(clientId) ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String token;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        FormComponent form = (FormComponent)component;
        String action = form.getAction();
        ModuleConfig moduleConfig = form.lookupModuleConfig(context);
        ActionConfig actionConfig = moduleConfig.findActionConfig(action);
        if (actionConfig == null) {
            throw new IllegalArgumentException("Cannot find action '" + action + "' configuration");
        }
        String beanName = actionConfig.getAttribute();
        if (beanName != null) {
            form.getAttributes().put("beanName", beanName);
        }
        String clientId = component.getClientId(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)("encodeBegin(" + clientId + ")"));
        }
        String styleClass = (String)component.getAttributes().get("styleClass");
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("form", (UIComponent)form);
        writer.writeAttribute("id", (Object)clientId, "clientId");
        if (beanName != null) {
            writer.writeAttribute("name", (Object)beanName, null);
        }
        writer.writeAttribute("action", (Object)this.action(context, component), "action");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (component.getAttributes().get("method") == null) {
            writer.writeAttribute("method", (Object)"post", null);
        }
        this.renderPassThrough(context, component, writer, passThrough);
        writer.writeText((Object)"\n", null);
        writer.startElement("input", (UIComponent)form);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("value", (Object)clientId, null);
        writer.endElement("input");
        writer.writeText((Object)"\n", null);
        HttpSession session = (HttpSession)context.getExternalContext().getSession(false);
        if (session != null && (token = (String)session.getAttribute("org.apache.struts.action.TOKEN")) != null) {
            writer.startElement("input", (UIComponent)form);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("name", (Object)"org.apache.struts.taglib.html.TOKEN", null);
            writer.writeAttribute("value", (Object)token, null);
            writer.endElement("input");
            writer.writeText((Object)"\n", null);
        }
        if (component instanceof FormComponent) {
            ((FormComponent)component).createActionForm(context);
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String clientId = component.getClientId(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)("encodeEnd(" + clientId + ")"));
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)component.getClientId(context), null);
        writer.writeAttribute("value", (Object)component.getClientId(context), null);
        writer.endElement("input");
        writer.write("\n");
        context.getApplication().getViewHandler().writeState(context);
        writer.endElement("form");
        writer.writeText((Object)"\n", null);
        if (!(component instanceof FormComponent)) {
            return;
        }
        String focus = (String)component.getAttributes().get("focus");
        if (focus == null) {
            return;
        }
        String focusIndex = (String)component.getAttributes().get("focusIndex");
        writer.writeText((Object)"\n", null);
        FormComponent form = (FormComponent)component;
        writer.startElement("script", (UIComponent)form);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        if (!this.isXhtml(component)) {
            writer.writeAttribute("language", (Object)"JavaScript", null);
        }
        writer.writeText((Object)"\n", null);
        if (!this.isXhtml(component)) {
            writer.write("<!--\n");
        }
        StringBuffer sb = new StringBuffer("document.forms[\"");
        sb.append(clientId);
        sb.append("\"].elements[\"");
        sb.append(component.getClientId(context));
        sb.append(':');
        sb.append(focus);
        sb.append("\"]");
        String focusControl = sb.toString();
        writer.write("  var focusControl = ");
        writer.write(focusControl);
        writer.write(";\n");
        writer.write("  if (focusControl.type != \"hidden\") {\n");
        writer.write("    ");
        writer.write(focusControl);
        if (focusIndex != null) {
            writer.write("[");
            writer.write(focusIndex);
            writer.write("]");
        }
        writer.write(".focus();\n");
        writer.write("  }\n");
        if (!this.isXhtml(component)) {
            writer.write("// -->\n");
        }
        writer.endElement("script");
        writer.writeText((Object)"\n", null);
    }

    protected String action(FacesContext context, UIComponent component) {
        String actionURL = context.getApplication().getViewHandler().getActionURL(context, context.getViewRoot().getViewId());
        if (log.isTraceEnabled()) {
            log.trace((Object)("getActionURL(" + context.getViewRoot().getViewId() + ") --> " + actionURL));
        }
        return context.getExternalContext().encodeActionURL(actionURL);
    }

    protected boolean isXhtml(UIComponent component) {
        return false;
    }
}

