/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import java.io.IOException;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.faces.renderer.AbstractRenderer;

public class HtmlRenderer
extends AbstractRenderer {
    private static Log log = LogFactory.getLog(HtmlRenderer.class);

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Locale currentLocale = this.getCurrentLocale(context, component);
        String lang = currentLocale.getLanguage();
        boolean validLanguage = lang != null && lang.length() > 0;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("html", component);
        if (this.isXhtml(component)) {
            writer.writeAttribute("xmlns", (Object)"http://www.w3.org/1999/xhtml", null);
        }
        if ((this.isLocale(component) || this.isXhtml(component)) && validLanguage) {
            writer.writeAttribute("lang", (Object)lang, null);
        }
        if (this.isXhtml(component) && validLanguage) {
            writer.writeAttribute("xml:lang", (Object)lang, null);
        }
        writer.writeText((Object)"\n", null);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("html");
    }

    protected Locale getCurrentLocale(FacesContext context, UIComponent component) {
        if (!this.isLocale(component)) {
            return context.getExternalContext().getRequestLocale();
        }
        HttpSession session = (HttpSession)context.getExternalContext().getSession(true);
        Locale current = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (current != null) {
            return current;
        }
        current = context.getExternalContext().getRequestLocale();
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)current);
        return current;
    }

    protected boolean isLocale(UIComponent component) {
        Boolean locale = (Boolean)component.getAttributes().get("locale");
        if (locale != null) {
            return locale;
        }
        return false;
    }

    protected boolean isXhtml(UIComponent component) {
        Boolean xhtml = (Boolean)component.getAttributes().get("xhtml");
        if (xhtml != null) {
            return xhtml;
        }
        return false;
    }
}

